/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.datafixers.DataFixUtils;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.debugchart.BandwidthDebugChart;
import net.minecraft.client.gui.components.debugchart.FpsDebugChart;
import net.minecraft.client.gui.components.debugchart.PingDebugChart;
import net.minecraft.client.gui.components.debugchart.TpsDebugChart;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.Connection;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.debugchart.LocalSampleLogger;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DebugScreenOverlay {
    private static final int COLOR_GREY = 0xE0E0E0;
    private static final int MARGIN_RIGHT = 2;
    private static final int MARGIN_LEFT = 2;
    private static final int MARGIN_TOP = 2;
    private static final Map<Heightmap.Types, String> HEIGHTMAP_NAMES = Util.make(new EnumMap(Heightmap.Types.class), p_94070_ -> {
        p_94070_.put(Heightmap.Types.WORLD_SURFACE_WG, "SW");
        p_94070_.put(Heightmap.Types.WORLD_SURFACE, "S");
        p_94070_.put(Heightmap.Types.OCEAN_FLOOR_WG, "OW");
        p_94070_.put(Heightmap.Types.OCEAN_FLOOR, "O");
        p_94070_.put(Heightmap.Types.MOTION_BLOCKING, "M");
        p_94070_.put(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, "ML");
    });
    private final Minecraft minecraft;
    private final AllocationRateCalculator allocationRateCalculator;
    private final Font font;
    private HitResult block;
    private HitResult liquid;
    @Nullable
    private ChunkPos lastPos;
    @Nullable
    private LevelChunk clientChunk;
    @Nullable
    private CompletableFuture<LevelChunk> serverChunk;
    private boolean renderDebug;
    private boolean renderProfilerChart;
    private boolean renderFpsCharts;
    private boolean renderNetworkCharts;
    private final LocalSampleLogger frameTimeLogger = new LocalSampleLogger(1);
    private final LocalSampleLogger tickTimeLogger = new LocalSampleLogger(TpsDebugDimensions.values().length);
    private final LocalSampleLogger pingLogger = new LocalSampleLogger(1);
    private final LocalSampleLogger bandwidthLogger = new LocalSampleLogger(1);
    private final Map<RemoteDebugSampleType, LocalSampleLogger> remoteSupportingLoggers = Map.of(RemoteDebugSampleType.TICK_TIME, this.tickTimeLogger);
    private final FpsDebugChart fpsChart;
    private final TpsDebugChart tpsChart;
    private final PingDebugChart pingChart;
    private final BandwidthDebugChart bandwidthChart;

    public DebugScreenOverlay(Minecraft p_94039_) {
        this.minecraft = p_94039_;
        this.allocationRateCalculator = new AllocationRateCalculator();
        this.font = p_94039_.font;
        this.fpsChart = new FpsDebugChart(this.font, this.frameTimeLogger);
        this.tpsChart = new TpsDebugChart(this.font, this.tickTimeLogger, () -> Float.valueOf(p_308449_.level.tickRateManager().millisecondsPerTick()));
        this.pingChart = new PingDebugChart(this.font, this.pingLogger);
        this.bandwidthChart = new BandwidthDebugChart(this.font, this.bandwidthLogger);
    }

    public void clearChunkCache() {
        this.serverChunk = null;
        this.clientChunk = null;
    }

    public void render(GuiGraphics p_281427_) {
        this.minecraft.getProfiler().push("debug");
        Entity $$1 = this.minecraft.getCameraEntity();
        this.block = $$1.pick(20.0, 0.0f, false);
        this.liquid = $$1.pick(20.0, 0.0f, true);
        p_281427_.drawManaged(() -> {
            this.drawGameInformation(p_281427_);
            this.drawSystemInformation(p_281427_);
            if (this.renderFpsCharts) {
                int $$1 = p_281427_.guiWidth();
                int $$2 = $$1 / 2;
                this.fpsChart.drawChart(p_281427_, 0, this.fpsChart.getWidth($$2));
                if (this.tickTimeLogger.size() > 0) {
                    int $$3 = this.tpsChart.getWidth($$2);
                    this.tpsChart.drawChart(p_281427_, $$1 - $$3, $$3);
                }
            }
            if (this.renderNetworkCharts) {
                int $$4 = p_281427_.guiWidth();
                int $$5 = $$4 / 2;
                if (!this.minecraft.isLocalServer()) {
                    this.bandwidthChart.drawChart(p_281427_, 0, this.bandwidthChart.getWidth($$5));
                }
                int $$6 = this.pingChart.getWidth($$5);
                this.pingChart.drawChart(p_281427_, $$4 - $$6, $$6);
            }
        });
        this.minecraft.getProfiler().pop();
    }

    protected void drawGameInformation(GuiGraphics p_281525_) {
        List<String> $$1 = this.getGameInformation();
        $$1.add("");
        boolean $$2 = this.minecraft.getSingleplayerServer() != null;
        $$1.add("Debug charts: [F3+1] Profiler " + (this.renderProfilerChart ? "visible" : "hidden") + "; [F3+2] " + ($$2 ? "FPS + TPS " : "FPS ") + (this.renderFpsCharts ? "visible" : "hidden") + "; [F3+3] " + (!this.minecraft.isLocalServer() ? "Bandwidth + Ping" : "Ping") + (this.renderNetworkCharts ? " visible" : " hidden"));
        $$1.add("For help: press F3 + Q");
        this.renderLines(p_281525_, $$1, true);
    }

    protected void drawSystemInformation(GuiGraphics p_281261_) {
        List<String> $$1 = this.getSystemInformation();
        this.renderLines(p_281261_, $$1, false);
    }

    private void renderLines(GuiGraphics p_286519_, List<String> p_286665_, boolean p_286644_) {
        int $$3 = this.font.lineHeight;
        for (int $$4 = 0; $$4 < p_286665_.size(); ++$$4) {
            String $$5 = p_286665_.get($$4);
            if (Strings.isNullOrEmpty((String)$$5)) continue;
            int $$6 = this.font.width($$5);
            int $$7 = p_286644_ ? 2 : p_286519_.guiWidth() - 2 - $$6;
            int $$8 = 2 + $$3 * $$4;
            p_286519_.fill($$7 - 1, $$8 - 1, $$7 + $$6 + 1, $$8 + $$3 - 1, -1873784752);
        }
        for (int $$9 = 0; $$9 < p_286665_.size(); ++$$9) {
            String $$10 = p_286665_.get($$9);
            if (Strings.isNullOrEmpty((String)$$10)) continue;
            int $$11 = this.font.width($$10);
            int $$12 = p_286644_ ? 2 : p_286519_.guiWidth() - 2 - $$11;
            int $$13 = 2 + $$3 * $$9;
            p_286519_.drawString(this.font, $$10, $$12, $$13, 0xE0E0E0, false);
        }
    }

    protected List<String> getGameInformation() {
        PostChain $$47;
        Level $$23;
        String $$21;
        String $$13;
        String $$8;
        IntegratedServer $$0 = this.minecraft.getSingleplayerServer();
        ClientPacketListener $$1 = this.minecraft.getConnection();
        Connection $$2 = $$1.getConnection();
        float $$3 = $$2.getAverageSentPackets();
        float $$4 = $$2.getAverageReceivedPackets();
        TickRateManager $$5 = this.getLevel().tickRateManager();
        if ($$5.isSteppingForward()) {
            String $$6 = " (frozen - stepping)";
        } else if ($$5.isFrozen()) {
            String $$7 = " (frozen)";
        } else {
            $$8 = "";
        }
        if ($$0 != null) {
            ServerTickRateManager $$9 = $$0.tickRateManager();
            boolean $$10 = $$9.isSprinting();
            if ($$10) {
                $$8 = " (sprinting)";
            }
            String $$11 = $$10 ? "-" : String.format(Locale.ROOT, "%.1f", Float.valueOf($$5.millisecondsPerTick()));
            String $$12 = String.format(Locale.ROOT, "Integrated server @ %.1f/%s ms%s, %.0f tx, %.0f rx", Float.valueOf($$0.getCurrentSmoothedTickTime()), $$11, $$8, Float.valueOf($$3), Float.valueOf($$4));
        } else {
            $$13 = String.format(Locale.ROOT, "\"%s\" server%s, %.0f tx, %.0f rx", $$1.serverBrand(), $$8, Float.valueOf($$3), Float.valueOf($$4));
        }
        BlockPos $$14 = this.minecraft.getCameraEntity().blockPosition();
        if (this.minecraft.showOnlyReducedInfo()) {
            return Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.getCurrentVersion().getName() + " (" + this.minecraft.getLaunchedVersion() + "/" + ClientBrandRetriever.getClientModName() + ")", this.minecraft.fpsString, $$13, this.minecraft.levelRenderer.getSectionStatistics(), this.minecraft.levelRenderer.getEntityStatistics(), "P: " + this.minecraft.particleEngine.countParticles() + ". T: " + this.minecraft.level.getEntityCount(), this.minecraft.level.gatherChunkSourceStats(), "", String.format(Locale.ROOT, "Chunk-relative: %d %d %d", $$14.getX() & 0xF, $$14.getY() & 0xF, $$14.getZ() & 0xF)});
        }
        Entity $$15 = this.minecraft.getCameraEntity();
        Direction $$16 = $$15.getDirection();
        switch ($$16) {
            case NORTH: {
                String $$17 = "Towards negative Z";
                break;
            }
            case SOUTH: {
                String $$18 = "Towards positive Z";
                break;
            }
            case WEST: {
                String $$19 = "Towards negative X";
                break;
            }
            case EAST: {
                String $$20 = "Towards positive X";
                break;
            }
            default: {
                $$21 = "Invalid";
            }
        }
        ChunkPos $$22 = new ChunkPos($$14);
        if (!Objects.equals(this.lastPos, $$22)) {
            this.lastPos = $$22;
            this.clearChunkCache();
        }
        LongSets.EmptySet $$24 = ($$23 = this.getLevel()) instanceof ServerLevel ? ((ServerLevel)$$23).getForcedChunks() : LongSets.EMPTY_SET;
        ArrayList $$25 = Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.getCurrentVersion().getName() + " (" + this.minecraft.getLaunchedVersion() + "/" + ClientBrandRetriever.getClientModName() + (String)("release".equalsIgnoreCase(this.minecraft.getVersionType()) ? "" : "/" + this.minecraft.getVersionType()) + ")", this.minecraft.fpsString, $$13, this.minecraft.levelRenderer.getSectionStatistics(), this.minecraft.levelRenderer.getEntityStatistics(), "P: " + this.minecraft.particleEngine.countParticles() + ". T: " + this.minecraft.level.getEntityCount(), this.minecraft.level.gatherChunkSourceStats()});
        String $$26 = this.getServerChunkStats();
        if ($$26 != null) {
            $$25.add($$26);
        }
        $$25.add(String.valueOf(this.minecraft.level.dimension().location()) + " FC: " + $$24.size());
        $$25.add("");
        $$25.add(String.format(Locale.ROOT, "XYZ: %.3f / %.5f / %.3f", this.minecraft.getCameraEntity().getX(), this.minecraft.getCameraEntity().getY(), this.minecraft.getCameraEntity().getZ()));
        $$25.add(String.format(Locale.ROOT, "Block: %d %d %d [%d %d %d]", $$14.getX(), $$14.getY(), $$14.getZ(), $$14.getX() & 0xF, $$14.getY() & 0xF, $$14.getZ() & 0xF));
        $$25.add(String.format(Locale.ROOT, "Chunk: %d %d %d [%d %d in r.%d.%d.mca]", $$22.x, SectionPos.blockToSectionCoord($$14.getY()), $$22.z, $$22.getRegionLocalX(), $$22.getRegionLocalZ(), $$22.getRegionX(), $$22.getRegionZ()));
        $$25.add(String.format(Locale.ROOT, "Facing: %s (%s) (%.1f / %.1f)", $$16, $$21, Float.valueOf(Mth.wrapDegrees($$15.getYRot())), Float.valueOf(Mth.wrapDegrees($$15.getXRot()))));
        LevelChunk $$27 = this.getClientChunk();
        if ($$27.isEmpty()) {
            $$25.add("Waiting for chunk...");
        } else {
            int $$28 = this.minecraft.level.getChunkSource().getLightEngine().getRawBrightness($$14, 0);
            int $$29 = this.minecraft.level.getBrightness(LightLayer.SKY, $$14);
            int $$30 = this.minecraft.level.getBrightness(LightLayer.BLOCK, $$14);
            $$25.add("Client Light: " + $$28 + " (" + $$29 + " sky, " + $$30 + " block)");
            LevelChunk $$31 = this.getServerChunk();
            StringBuilder $$32 = new StringBuilder("CH");
            for (Heightmap.Types $$33 : Heightmap.Types.values()) {
                if (!$$33.sendToClient()) continue;
                $$32.append(" ").append(HEIGHTMAP_NAMES.get($$33)).append(": ").append($$27.getHeight($$33, $$14.getX(), $$14.getZ()));
            }
            $$25.add($$32.toString());
            $$32.setLength(0);
            $$32.append("SH");
            for (Heightmap.Types $$34 : Heightmap.Types.values()) {
                if (!$$34.keepAfterWorldgen()) continue;
                $$32.append(" ").append(HEIGHTMAP_NAMES.get($$34)).append(": ");
                if ($$31 != null) {
                    $$32.append($$31.getHeight($$34, $$14.getX(), $$14.getZ()));
                    continue;
                }
                $$32.append("??");
            }
            $$25.add($$32.toString());
            if ($$14.getY() >= this.minecraft.level.getMinBuildHeight() && $$14.getY() < this.minecraft.level.getMaxBuildHeight()) {
                $$25.add("Biome: " + DebugScreenOverlay.printBiome(this.minecraft.level.getBiome($$14)));
                if ($$31 != null) {
                    float $$35 = $$23.getMoonBrightness();
                    long $$36 = $$31.getInhabitedTime();
                    DifficultyInstance $$37 = new DifficultyInstance($$23.getDifficulty(), $$23.getDayTime(), $$36, $$35);
                    $$25.add(String.format(Locale.ROOT, "Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf($$37.getEffectiveDifficulty()), Float.valueOf($$37.getSpecialMultiplier()), this.minecraft.level.getDayTime() / 24000L));
                } else {
                    $$25.add("Local Difficulty: ??");
                }
            }
            if ($$31 != null && $$31.isOldNoiseGeneration()) {
                $$25.add("Blending: Old");
            }
        }
        ServerLevel $$38 = this.getServerLevel();
        if ($$38 != null) {
            ServerChunkCache $$39 = $$38.getChunkSource();
            ChunkGenerator $$40 = $$39.getGenerator();
            RandomState $$41 = $$39.randomState();
            $$40.addDebugScreenInfo($$25, $$41, $$14);
            Climate.Sampler $$42 = $$41.sampler();
            BiomeSource $$43 = $$40.getBiomeSource();
            $$43.addDebugInfo($$25, $$14, $$42);
            NaturalSpawner.SpawnState $$44 = $$39.getLastSpawnState();
            if ($$44 != null) {
                Object2IntMap<MobCategory> $$45 = $$44.getMobCategoryCounts();
                int $$46 = $$44.getSpawnableChunkCount();
                $$25.add("SC: " + $$46 + ", " + Stream.of(MobCategory.values()).map(p_94068_ -> Character.toUpperCase(p_94068_.getName().charAt(0)) + ": " + $$45.getInt(p_94068_)).collect(Collectors.joining(", ")));
            } else {
                $$25.add("SC: N/A");
            }
        }
        if (($$47 = this.minecraft.gameRenderer.currentEffect()) != null) {
            $$25.add("Shader: " + $$47.getName());
        }
        $$25.add(this.minecraft.getSoundManager().getDebugString() + String.format(Locale.ROOT, " (Mood %d%%)", Math.round(this.minecraft.player.getCurrentMood() * 100.0f)));
        return $$25;
    }

    private static String printBiome(Holder<Biome> p_205375_) {
        return (String)p_205375_.unwrap().map(p_205377_ -> p_205377_.location().toString(), p_339278_ -> "[unregistered " + String.valueOf(p_339278_) + "]");
    }

    @Nullable
    private ServerLevel getServerLevel() {
        IntegratedServer $$0 = this.minecraft.getSingleplayerServer();
        if ($$0 != null) {
            return $$0.getLevel(this.minecraft.level.dimension());
        }
        return null;
    }

    @Nullable
    private String getServerChunkStats() {
        ServerLevel $$0 = this.getServerLevel();
        if ($$0 != null) {
            return $$0.gatherChunkSourceStats();
        }
        return null;
    }

    private Level getLevel() {
        return (Level)DataFixUtils.orElse(Optional.ofNullable(this.minecraft.getSingleplayerServer()).flatMap(p_340608_ -> Optional.ofNullable(p_340608_.getLevel(this.minecraft.level.dimension()))), (Object)this.minecraft.level);
    }

    @Nullable
    private LevelChunk getServerChunk() {
        if (this.serverChunk == null) {
            ServerLevel $$0 = this.getServerLevel();
            if ($$0 == null) {
                return null;
            }
            this.serverChunk = $$0.getChunkSource().getChunkFuture(this.lastPos.x, this.lastPos.z, ChunkStatus.FULL, false).thenApply(p_329714_ -> p_329714_.orElse(null));
        }
        return this.serverChunk.getNow(null);
    }

    private LevelChunk getClientChunk() {
        if (this.clientChunk == null) {
            this.clientChunk = this.minecraft.level.getChunk(this.lastPos.x, this.lastPos.z);
        }
        return this.clientChunk;
    }

    protected List<String> getSystemInformation() {
        Entity $$11;
        long $$0 = Runtime.getRuntime().maxMemory();
        long $$1 = Runtime.getRuntime().totalMemory();
        long $$2 = Runtime.getRuntime().freeMemory();
        long $$3 = $$1 - $$2;
        ArrayList $$4 = Lists.newArrayList((Object[])new String[]{String.format(Locale.ROOT, "Java: %s", System.getProperty("java.version")), String.format(Locale.ROOT, "Mem: %2d%% %03d/%03dMB", $$3 * 100L / $$0, DebugScreenOverlay.bytesToMegabytes($$3), DebugScreenOverlay.bytesToMegabytes($$0)), String.format(Locale.ROOT, "Allocation rate: %03dMB/s", DebugScreenOverlay.bytesToMegabytes(this.allocationRateCalculator.bytesAllocatedPerSecond($$3))), String.format(Locale.ROOT, "Allocated: %2d%% %03dMB", $$1 * 100L / $$0, DebugScreenOverlay.bytesToMegabytes($$1)), "", String.format(Locale.ROOT, "CPU: %s", GlUtil.getCpuInfo()), "", String.format(Locale.ROOT, "Display: %dx%d (%s)", Minecraft.getInstance().getWindow().getWidth(), Minecraft.getInstance().getWindow().getHeight(), GlUtil.getVendor()), GlUtil.getRenderer(), GlUtil.getOpenGLVersion()});
        if (this.minecraft.showOnlyReducedInfo()) {
            return $$4;
        }
        if (this.block.getType() == HitResult.Type.BLOCK) {
            BlockPos $$5 = ((BlockHitResult)this.block).getBlockPos();
            BlockState $$6 = this.minecraft.level.getBlockState($$5);
            $$4.add("");
            $$4.add(String.valueOf(ChatFormatting.UNDERLINE) + "Targeted Block: " + $$5.getX() + ", " + $$5.getY() + ", " + $$5.getZ());
            $$4.add(String.valueOf(BuiltInRegistries.BLOCK.getKey($$6.getBlock())));
            for (Map.Entry<Property<?>, Comparable<?>> $$7 : $$6.getValues().entrySet()) {
                $$4.add(this.getPropertyValueString($$7));
            }
            $$6.getTags().map(p_339277_ -> "#" + String.valueOf(p_339277_.location())).forEach($$4::add);
        }
        if (this.liquid.getType() == HitResult.Type.BLOCK) {
            BlockPos $$8 = ((BlockHitResult)this.liquid).getBlockPos();
            FluidState $$9 = this.minecraft.level.getFluidState($$8);
            $$4.add("");
            $$4.add(String.valueOf(ChatFormatting.UNDERLINE) + "Targeted Fluid: " + $$8.getX() + ", " + $$8.getY() + ", " + $$8.getZ());
            $$4.add(String.valueOf(BuiltInRegistries.FLUID.getKey($$9.getType())));
            for (Map.Entry<Property<?>, Comparable<?>> $$10 : $$9.getValues().entrySet()) {
                $$4.add(this.getPropertyValueString($$10));
            }
            $$9.getTags().map(p_339279_ -> "#" + String.valueOf(p_339279_.location())).forEach($$4::add);
        }
        if (($$11 = this.minecraft.crosshairPickEntity) != null) {
            $$4.add("");
            $$4.add(String.valueOf(ChatFormatting.UNDERLINE) + "Targeted Entity");
            $$4.add(String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey($$11.getType())));
        }
        return $$4;
    }

    private String getPropertyValueString(Map.Entry<Property<?>, Comparable<?>> p_94072_) {
        Property<?> $$1 = p_94072_.getKey();
        Comparable<?> $$2 = p_94072_.getValue();
        Object $$3 = Util.getPropertyName($$1, $$2);
        if (Boolean.TRUE.equals($$2)) {
            $$3 = String.valueOf(ChatFormatting.GREEN) + (String)$$3;
        } else if (Boolean.FALSE.equals($$2)) {
            $$3 = String.valueOf(ChatFormatting.RED) + (String)$$3;
        }
        return $$1.getName() + ": " + (String)$$3;
    }

    private static long bytesToMegabytes(long p_94051_) {
        return p_94051_ / 1024L / 1024L;
    }

    public boolean showDebugScreen() {
        return this.renderDebug && !this.minecraft.options.hideGui;
    }

    public boolean showProfilerChart() {
        return this.showDebugScreen() && this.renderProfilerChart;
    }

    public boolean showNetworkCharts() {
        return this.showDebugScreen() && this.renderNetworkCharts;
    }

    public boolean showFpsCharts() {
        return this.showDebugScreen() && this.renderFpsCharts;
    }

    public void toggleOverlay() {
        this.renderDebug = !this.renderDebug;
    }

    public void toggleNetworkCharts() {
        boolean bl = this.renderNetworkCharts = !this.renderDebug || !this.renderNetworkCharts;
        if (this.renderNetworkCharts) {
            this.renderDebug = true;
            this.renderFpsCharts = false;
        }
    }

    public void toggleFpsCharts() {
        boolean bl = this.renderFpsCharts = !this.renderDebug || !this.renderFpsCharts;
        if (this.renderFpsCharts) {
            this.renderDebug = true;
            this.renderNetworkCharts = false;
        }
    }

    public void toggleProfilerChart() {
        boolean bl = this.renderProfilerChart = !this.renderDebug || !this.renderProfilerChart;
        if (this.renderProfilerChart) {
            this.renderDebug = true;
        }
    }

    public void logFrameDuration(long p_299936_) {
        this.frameTimeLogger.logSample(p_299936_);
    }

    public LocalSampleLogger getTickTimeLogger() {
        return this.tickTimeLogger;
    }

    public LocalSampleLogger getPingLogger() {
        return this.pingLogger;
    }

    public LocalSampleLogger getBandwidthLogger() {
        return this.bandwidthLogger;
    }

    public void logRemoteSample(long[] p_324375_, RemoteDebugSampleType p_324309_) {
        LocalSampleLogger $$2 = this.remoteSupportingLoggers.get((Object)p_324309_);
        if ($$2 != null) {
            $$2.logFullSample(p_324375_);
        }
    }

    public void reset() {
        this.renderDebug = false;
        this.tickTimeLogger.reset();
        this.pingLogger.reset();
        this.bandwidthLogger.reset();
    }

    static class AllocationRateCalculator {
        private static final int UPDATE_INTERVAL_MS = 500;
        private static final List<GarbageCollectorMXBean> GC_MBEANS = ManagementFactory.getGarbageCollectorMXBeans();
        private long lastTime = 0L;
        private long lastHeapUsage = -1L;
        private long lastGcCounts = -1L;
        private long lastRate = 0L;

        AllocationRateCalculator() {
        }

        long bytesAllocatedPerSecond(long p_232517_) {
            long $$1 = System.currentTimeMillis();
            if ($$1 - this.lastTime < 500L) {
                return this.lastRate;
            }
            long $$2 = AllocationRateCalculator.gcCounts();
            if (this.lastTime != 0L && $$2 == this.lastGcCounts) {
                double $$3 = (double)TimeUnit.SECONDS.toMillis(1L) / (double)($$1 - this.lastTime);
                long $$4 = p_232517_ - this.lastHeapUsage;
                this.lastRate = Math.round((double)$$4 * $$3);
            }
            this.lastTime = $$1;
            this.lastHeapUsage = p_232517_;
            this.lastGcCounts = $$2;
            return this.lastRate;
        }

        private static long gcCounts() {
            long $$0 = 0L;
            for (GarbageCollectorMXBean $$1 : GC_MBEANS) {
                $$0 += $$1.getCollectionCount();
            }
            return $$0;
        }
    }
}

